/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.util;

import cy.jdkdigital.productivebees.ProductiveBees;
import cy.jdkdigital.productivebees.common.block.Feeder;
import cy.jdkdigital.productivebees.common.block.entity.FeederBlockEntity;
import cy.jdkdigital.productivebees.common.entity.bee.ConfigurableBee;
import cy.jdkdigital.productivebees.common.entity.bee.ProductiveBee;
import cy.jdkdigital.productivebees.common.item.StoneChip;
import cy.jdkdigital.productivebees.common.item.WoodChip;
import cy.jdkdigital.productivebees.common.recipe.AdvancedBeehiveRecipe;
import cy.jdkdigital.productivebees.common.recipe.BeeBreedingRecipe;
import cy.jdkdigital.productivebees.common.recipe.BeeConversionRecipe;
import cy.jdkdigital.productivebees.common.recipe.BlockConversionRecipe;
import cy.jdkdigital.productivebees.common.recipe.CentrifugeRecipe;
import cy.jdkdigital.productivebees.init.ModEntities;
import cy.jdkdigital.productivebees.init.ModRecipeTypes;
import cy.jdkdigital.productivebees.init.ModTags;
import cy.jdkdigital.productivebees.integrations.jei.ingredients.BeeIngredient;
import cy.jdkdigital.productivebees.setup.BeeReloadListener;
import cy.jdkdigital.productivebees.util.BeeAttribute;
import cy.jdkdigital.productivebees.util.BeeAttributes;
import cy.jdkdigital.productivebees.util.ColorUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.RecipeWrapper;
import net.minecraftforge.registries.ForgeRegistries;

public class BeeHelper {
    private static Map<String, List<BlockConversionRecipe>> blockConversionRecipeMap = new HashMap<String, List<BlockConversionRecipe>>();

    public static Entity itemInteract(Bee entity, ItemStack itemStack, ServerLevel world, CompoundTag nbt, Player player) {
        Entity bee = null;
        if (!entity.m_6162_()) {
            IdentifierInventory beeInv = new IdentifierInventory(entity, "" + itemStack.m_41720_().getRegistryName());
            ArrayList<BeeConversionRecipe> recipes = new ArrayList<BeeConversionRecipe>();
            Map allRecipes = world.m_7465_().m_44054_(ModRecipeTypes.BEE_CONVERSION_TYPE);
            for (Map.Entry entry : allRecipes.entrySet()) {
                BeeConversionRecipe recipe = (BeeConversionRecipe)entry.getValue();
                if (!recipe.m_5818_(beeInv, (Level)world)) continue;
                recipes.add(recipe);
            }
            if (!recipes.isEmpty()) {
                BeeConversionRecipe recipe = (BeeConversionRecipe)recipes.get(ProductiveBees.rand.nextInt(recipes.size()));
                if (ProductiveBees.rand.nextInt(100) < recipe.chance) {
                    bee = ((BeeIngredient)recipe.result.get()).getBeeEntity().m_20615_((Level)world);
                    if (bee instanceof ConfigurableBee) {
                        ((ConfigurableBee)bee).setBeeType(((BeeIngredient)recipe.result.get()).getBeeType().toString());
                        ((ConfigurableBee)bee).setAttributes();
                    }
                    if (bee instanceof ProductiveBee && entity instanceof ProductiveBee) {
                        BeeHelper.setOffspringAttributes((ProductiveBee)bee, (ProductiveBee)entity, (AgeableMob)entity);
                    }
                }
            }
        }
        if (bee != null) {
            if (!player.m_7500_()) {
                itemStack.m_41774_(1);
            }
            BlockPos pos = entity.m_142538_();
            bee.m_7678_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5, bee.m_146908_(), bee.m_146909_());
            if (bee instanceof LivingEntity) {
                ((LivingEntity)bee).m_21153_(entity.m_21223_());
                ((LivingEntity)bee).f_20883_ = entity.f_20883_;
            }
            if (bee instanceof Animal && entity.m_146764_() > 0) {
                ((Animal)bee).m_146762_(entity.m_146764_());
            }
            return bee;
        }
        return null;
    }

    @Nullable
    public static Entity getBreedingResult(Bee beeEntity, AgeableMob targetEntity, ServerLevel world) {
        ResourceLocation type;
        CompoundTag nbt;
        BeeIngredient beeIngredient;
        BeeBreedingRecipe recipe = BeeHelper.getRandomBreedingRecipe(beeEntity, targetEntity, world);
        if (recipe != null && recipe.offspring != null && (beeIngredient = (BeeIngredient)recipe.offspring.get()) != null) {
            Entity newBee = beeIngredient.getBeeEntity().m_20615_((Level)world);
            if (newBee instanceof ConfigurableBee) {
                ((ConfigurableBee)newBee).setBeeType(beeIngredient.getBeeType().toString());
                ((ConfigurableBee)newBee).setAttributes();
            }
            return newBee;
        }
        if (beeEntity instanceof ProductiveBee && !((ProductiveBee)beeEntity).canSelfBreed() || targetEntity instanceof ProductiveBee && !((ProductiveBee)targetEntity).canSelfBreed()) {
            return null;
        }
        if (beeEntity instanceof ConfigurableBee && (nbt = BeeReloadListener.INSTANCE.getData((type = new ResourceLocation(((ConfigurableBee)beeEntity).getBeeType())).toString())) != null && ((ConfigurableBee)beeEntity).canSelfBreed()) {
            ConfigurableBee newBee = (ConfigurableBee)((EntityType)ModEntities.CONFIGURABLE_BEE.get()).m_20615_((Level)world);
            newBee.setBeeType(type.toString());
            newBee.setAttributes();
            return newBee;
        }
        if (beeEntity != null && (!(beeEntity instanceof ProductiveBee) || ((ProductiveBee)beeEntity).canSelfBreed())) {
            return ((EntityType)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(beeEntity.m_20078_()))).m_20615_((Level)world);
        }
        return null;
    }

    public static BeeBreedingRecipe getRandomBreedingRecipe(Bee beeEntity, AgeableMob targetEntity, ServerLevel world) {
        IdentifierInventory beeInv = new IdentifierInventory(beeEntity, (Bee)targetEntity);
        ArrayList<BeeBreedingRecipe> recipes = new ArrayList<BeeBreedingRecipe>();
        Map allRecipes = world.m_7465_().m_44054_(ModRecipeTypes.BEE_BREEDING_TYPE);
        for (Map.Entry entry : allRecipes.entrySet()) {
            BeeBreedingRecipe recipe = (BeeBreedingRecipe)entry.getValue();
            if (!recipe.m_5818_(beeInv, (Level)world)) continue;
            recipes.add(recipe);
        }
        if (!recipes.isEmpty()) {
            return (BeeBreedingRecipe)recipes.get(ProductiveBees.rand.nextInt(recipes.size()));
        }
        return null;
    }

    public static BlockConversionRecipe getBlockConversionRecipe(Bee beeEntity, BlockState flowerBlockState) {
        List<Object> recipes = new ArrayList();
        String cacheKey = beeEntity.m_20078_() + flowerBlockState.toString();
        if (blockConversionRecipeMap.containsKey(cacheKey)) {
            recipes = blockConversionRecipeMap.get(cacheKey);
        } else if (beeEntity.f_19853_ instanceof ServerLevel) {
            BlockStateInventory beeInv = new BlockStateInventory(beeEntity, flowerBlockState);
            Map allRecipes = beeEntity.f_19853_.m_7465_().m_44054_(ModRecipeTypes.BLOCK_CONVERSION_TYPE);
            for (Map.Entry entry : allRecipes.entrySet()) {
                BlockConversionRecipe recipe = (BlockConversionRecipe)entry.getValue();
                if (!recipe.m_5818_(beeInv, beeEntity.f_19853_)) continue;
                recipes.add(recipe);
            }
            blockConversionRecipeMap.put(cacheKey, recipes);
        }
        if (!recipes.isEmpty()) {
            return (BlockConversionRecipe)recipes.get(ProductiveBees.rand.nextInt(recipes.size()));
        }
        return null;
    }

    public static boolean hasBlockConversionRecipe(Bee beeEntity, BlockState flowerBlockState) {
        return BeeHelper.getBlockConversionRecipe(beeEntity, flowerBlockState) != null;
    }

    public static List<ItemStack> getBeeProduce(Level world, Bee beeEntity, boolean hasCombBlockUpgrade) {
        ArrayList<ItemStack> outputList;
        block6: {
            Block flowerBlock;
            String beeId;
            BlockPos flowerPos;
            block8: {
                block7: {
                    block5: {
                        AdvancedBeehiveRecipe matchedRecipe = null;
                        flowerPos = beeEntity.m_27851_();
                        outputList = new ArrayList<ItemStack>();
                        beeId = beeEntity.m_20078_();
                        if (beeId == null) {
                            return outputList;
                        }
                        if (beeEntity instanceof ConfigurableBee) {
                            beeId = ((ConfigurableBee)beeEntity).getBeeType();
                        }
                        Map allRecipes = world.m_7465_().m_44054_(ModRecipeTypes.ADVANCED_BEEHIVE_TYPE);
                        IdentifierInventory beeInv = new IdentifierInventory(beeId);
                        for (Map.Entry entry : allRecipes.entrySet()) {
                            AdvancedBeehiveRecipe recipe = (AdvancedBeehiveRecipe)entry.getValue();
                            if (!recipe.m_5818_(beeInv, world)) continue;
                            matchedRecipe = recipe;
                        }
                        if (matchedRecipe == null) break block5;
                        matchedRecipe.getRecipeOutputs().forEach((itemStack, bounds) -> {
                            if (ProductiveBees.rand.nextInt(100) <= bounds.get(2).m_7047_()) {
                                int count = Mth.m_14072_((Random)ProductiveBees.rand, (int)Mth.m_14143_((float)bounds.get(0).m_7047_()), (int)Mth.m_14143_((float)bounds.get(1).m_7047_()));
                                ItemStack stack = itemStack.m_41777_();
                                stack.m_41764_(count);
                                outputList.add(stack);
                            }
                        });
                        break block6;
                    }
                    if (!beeId.equals("productivebees:lumber_bee")) break block7;
                    if (flowerPos == null || (flowerBlock = BeeHelper.getFloweringBlock(world, flowerPos, ModTags.LUMBER, (ProductiveBee)beeEntity)) == null) break block6;
                    ItemStack woodChip = hasCombBlockUpgrade ? new ItemStack((ItemLike)flowerBlock.m_5456_()) : WoodChip.getStack(flowerBlock, world.f_46441_.nextInt(6) + 1);
                    outputList.add(woodChip);
                    break block6;
                }
                if (!beeId.equals("productivebees:quarry_bee")) break block8;
                if (flowerPos == null || (flowerBlock = BeeHelper.getFloweringBlock(world, flowerPos, ModTags.QUARRY, (ProductiveBee)beeEntity)) == null) break block6;
                ItemStack stoneChip = hasCombBlockUpgrade ? new ItemStack((ItemLike)flowerBlock.m_5456_()) : StoneChip.getStack(flowerBlock, world.f_46441_.nextInt(6) + 1);
                outputList.add(stoneChip);
                break block6;
            }
            if (beeId.equals("productivebees:dye_bee") && flowerPos != null && (flowerBlock = BeeHelper.getFloweringBlock(world, flowerPos, (TagKey<Block>)BlockTags.f_13041_, (ProductiveBee)beeEntity)) != null) {
                Item flowerItem = flowerBlock.m_5456_();
                Map recipes = world.m_7465_().m_44054_(RecipeType.f_44107_);
                for (Map.Entry entry : recipes.entrySet()) {
                    Ingredient ingredient;
                    ItemStack[] stacks;
                    Recipe recipe = (Recipe)entry.getValue();
                    NonNullList ingredients = recipe.m_7527_();
                    if (ingredients.size() != 1 || (stacks = (ingredient = (Ingredient)ingredients.get(0)).m_43908_()).length <= 0 || !stacks[0].m_41720_().equals(flowerItem)) continue;
                    ItemStack dye = new ItemStack((ItemLike)recipe.m_8043_().m_41720_(), 1);
                    outputList.add(dye);
                    break;
                }
            }
        }
        return outputList;
    }

    @Nullable
    public static CentrifugeRecipe getCentrifugeRecipe(RecipeManager recipeManager, IItemHandlerModifiable inputHandler) {
        Level world = ProductiveBees.proxy.getWorld();
        if (world == null) {
            return null;
        }
        return recipeManager.m_44015_(ModRecipeTypes.CENTRIFUGE_TYPE, (Container)new RecipeWrapper(inputHandler), world).orElse(null);
    }

    private static Block getFloweringBlock(Level world, BlockPos flowerPos, TagKey<Block> tag, ProductiveBee bee) {
        BlockEntity feederTile;
        BlockState flowerBlockState = world.m_8055_(flowerPos);
        Block flowerBlock = flowerBlockState.m_60734_();
        if (flowerBlock instanceof Feeder && (feederTile = world.m_7702_(flowerPos)) instanceof FeederBlockEntity) {
            if (ProductiveBee.isValidFeeder(feederTile, bee::isFlowerBlock)) {
                return ((FeederBlockEntity)feederTile).getRandomBlockFromInventory(tag);
            }
        }
        return flowerBlockState.m_204336_(tag) ? flowerBlock : null;
    }

    public static void setOffspringAttributes(ProductiveBee newBee, ProductiveBee productiveBeeEntity, AgeableMob targetEntity) {
        Map<BeeAttribute<?>, Object> attributeMapParent1 = productiveBeeEntity.getBeeAttributes();
        Map<Object, Object> attributeMapParent2 = new HashMap<BeeAttribute<Integer>, Integer>();
        if (targetEntity instanceof ProductiveBee) {
            attributeMapParent2 = ((ProductiveBee)targetEntity).getBeeAttributes();
        } else {
            attributeMapParent2.put(BeeAttributes.PRODUCTIVITY, 0);
            attributeMapParent2.put(BeeAttributes.ENDURANCE, 0);
            attributeMapParent2.put(BeeAttributes.TEMPER, 1);
            attributeMapParent2.put(BeeAttributes.BEHAVIOR, 0);
            attributeMapParent2.put(BeeAttributes.WEATHER_TOLERANCE, 0);
        }
        Map<BeeAttribute<?>, Object> attributeMapChild = newBee.getBeeAttributes();
        int parentProductivity = Mth.m_14072_((Random)ProductiveBees.rand, (int)((Integer)attributeMapParent1.get(BeeAttributes.PRODUCTIVITY)), (int)((Integer)attributeMapParent2.get(BeeAttributes.PRODUCTIVITY)));
        attributeMapChild.put(BeeAttributes.PRODUCTIVITY, Math.max((Integer)attributeMapChild.get(BeeAttributes.PRODUCTIVITY), parentProductivity));
        int parentEndurance = Mth.m_14072_((Random)ProductiveBees.rand, (int)((Integer)attributeMapParent1.get(BeeAttributes.ENDURANCE)), (int)((Integer)attributeMapParent2.get(BeeAttributes.ENDURANCE)));
        attributeMapChild.put(BeeAttributes.ENDURANCE, Math.max((Integer)attributeMapChild.get(BeeAttributes.ENDURANCE), parentEndurance));
        int parentTemper = Mth.m_14072_((Random)ProductiveBees.rand, (int)((Integer)attributeMapParent1.get(BeeAttributes.TEMPER)), (int)((Integer)attributeMapParent2.get(BeeAttributes.TEMPER)));
        attributeMapChild.put(BeeAttributes.TEMPER, Math.min((Integer)attributeMapChild.get(BeeAttributes.TEMPER), parentTemper));
        int parentBehavior = Mth.m_14072_((Random)ProductiveBees.rand, (int)((Integer)attributeMapParent1.get(BeeAttributes.BEHAVIOR)), (int)((Integer)attributeMapParent2.get(BeeAttributes.BEHAVIOR)));
        attributeMapChild.put(BeeAttributes.BEHAVIOR, Math.max((Integer)attributeMapChild.get(BeeAttributes.BEHAVIOR), parentBehavior));
        int parentWeatherTolerance = Mth.m_14072_((Random)ProductiveBees.rand, (int)((Integer)attributeMapParent1.get(BeeAttributes.WEATHER_TOLERANCE)), (int)((Integer)attributeMapParent2.get(BeeAttributes.WEATHER_TOLERANCE)));
        attributeMapChild.put(BeeAttributes.WEATHER_TOLERANCE, Math.max((Integer)attributeMapChild.get(BeeAttributes.WEATHER_TOLERANCE), parentWeatherTolerance));
    }

    public static List<Component> populateBeeInfoFromTag(CompoundTag tag, @Nullable List<Component> list) {
        if (list == null) {
            list = new ArrayList<Component>();
        }
        list.add((Component)new TranslatableComponent(tag.m_128451_("Age") < 0 ? "productivebees.information.age.child" : "productivebees.information.age.adult").m_130940_(ChatFormatting.AQUA).m_130940_(ChatFormatting.ITALIC));
        if (tag.m_128471_("isProductiveBee")) {
            float current = tag.m_128457_("Health");
            float max = tag.m_128441_("MaxHealth") ? tag.m_128457_("MaxHealth") : 10.0f;
            list.add((Component)new TranslatableComponent("productivebees.information.attribute.health", new Object[]{Float.valueOf(current), Float.valueOf(max)}).m_130940_(ChatFormatting.DARK_GRAY));
            String type = tag.m_128461_("bee_type");
            MutableComponent type_value = new TranslatableComponent("productivebees.information.attribute.type." + type).m_130940_(ColorUtil.getColor(type));
            list.add((Component)new TranslatableComponent("productivebees.information.attribute.type", new Object[]{type_value}).m_130940_(ChatFormatting.DARK_GRAY));
            int productivity = tag.m_128451_("bee_productivity");
            MutableComponent productivity_value = new TranslatableComponent(BeeAttributes.keyMap.get(BeeAttributes.PRODUCTIVITY).get(productivity)).m_130940_(ColorUtil.getColor(productivity));
            list.add((Component)new TranslatableComponent("productivebees.information.attribute.productivity", new Object[]{productivity_value}).m_130940_(ChatFormatting.DARK_GRAY));
            int tolerance = tag.m_128451_("bee_weather_tolerance");
            MutableComponent tolerance_value = new TranslatableComponent(BeeAttributes.keyMap.get(BeeAttributes.WEATHER_TOLERANCE).get(tolerance)).m_130940_(ColorUtil.getColor(tolerance));
            list.add((Component)new TranslatableComponent("productivebees.information.attribute.weather_tolerance", new Object[]{tolerance_value}).m_130940_(ChatFormatting.DARK_GRAY));
            int behavior = tag.m_128451_("bee_behavior");
            MutableComponent behavior_value = new TranslatableComponent(BeeAttributes.keyMap.get(BeeAttributes.BEHAVIOR).get(behavior)).m_130940_(ColorUtil.getColor(behavior));
            list.add((Component)new TranslatableComponent("productivebees.information.attribute.behavior", new Object[]{behavior_value}).m_130940_(ChatFormatting.DARK_GRAY));
            int endurance = tag.m_128451_("bee_endurance");
            MutableComponent endurance_value = new TranslatableComponent(BeeAttributes.keyMap.get(BeeAttributes.ENDURANCE).get(endurance)).m_130940_(ColorUtil.getColor(endurance));
            list.add((Component)new TranslatableComponent("productivebees.information.attribute.endurance", new Object[]{endurance_value}).m_130940_(ChatFormatting.DARK_GRAY));
            int temper = tag.m_128451_("bee_temper");
            MutableComponent temper_value = new TranslatableComponent(BeeAttributes.keyMap.get(BeeAttributes.TEMPER).get(temper)).m_130940_(ColorUtil.getColor(temper));
            list.add((Component)new TranslatableComponent("productivebees.information.attribute.temper", new Object[]{temper_value}).m_130940_(ChatFormatting.DARK_GRAY));
            CompoundTag beeData = BeeReloadListener.INSTANCE.getData(tag.m_128461_("type"));
            TranslatableComponent breedingItemText = new TranslatableComponent("productivebees.information.breeding_item_default");
            if (beeData != null && beeData.m_128441_("breedingItem") && !beeData.m_128461_("breedingItem").isEmpty()) {
                Item breedingItem = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(beeData.m_128461_("breedingItem")));
                breedingItemText = new TextComponent(beeData.m_128451_("breedingItemCount") + " " + new TranslatableComponent(breedingItem.m_5524_()).getString());
            }
            list.add((Component)new TranslatableComponent("productivebees.information.breeding_item", new Object[]{breedingItemText.m_130940_(ChatFormatting.GRAY)}).m_130940_(ChatFormatting.DARK_GRAY));
            if (beeData != null && !beeData.m_128471_("selfbreed")) {
                list.add((Component)new TranslatableComponent("productivebees.information.selfbreed_disabled").m_130940_(ChatFormatting.GRAY));
            }
            if (tag.m_128441_("HivePos")) {
                BlockPos hivePos = NbtUtils.m_129239_((CompoundTag)tag.m_128469_("HivePos"));
                list.add((Component)new TranslatableComponent("productivebees.information.home_position", new Object[]{hivePos.m_123341_(), hivePos.m_123342_(), hivePos.m_123343_()}));
            }
        } else {
            list.add((Component)new TextComponent("Mod: " + tag.m_128461_("mod")).m_130940_(ChatFormatting.DARK_AQUA));
        }
        return list;
    }

    public static class IdentifierInventory
    implements Container {
        private final List<String> identifiers = new ArrayList<String>();

        public IdentifierInventory(String identifier) {
            this.identifiers.add(identifier);
        }

        public IdentifierInventory(Bee bee1, Bee bee2) {
            String identifier1 = bee1.m_20078_();
            if (bee1 instanceof ConfigurableBee) {
                identifier1 = ((ConfigurableBee)bee1).getBeeType();
            }
            String identifier2 = bee2.m_20078_();
            if (bee2 instanceof ConfigurableBee) {
                identifier2 = ((ConfigurableBee)bee2).getBeeType();
            }
            this.identifiers.add(identifier1);
            this.identifiers.add(identifier2);
        }

        public IdentifierInventory(Bee bee1, String identifier2) {
            String identifier1 = bee1.m_20078_();
            if (bee1 instanceof ConfigurableBee) {
                identifier1 = ((ConfigurableBee)bee1).getBeeType();
            }
            this.identifiers.add(identifier1);
            this.identifiers.add(identifier2);
        }

        public IdentifierInventory(String identifier1, String identifier2) {
            this.identifiers.add(identifier1);
            this.identifiers.add(identifier2);
        }

        public String getIdentifier() {
            return this.getIdentifier(0);
        }

        public String getIdentifier(int index) {
            return this.identifiers.get(index);
        }

        public int m_6643_() {
            return 1;
        }

        public boolean m_7983_() {
            return this.identifiers.isEmpty();
        }

        @Nonnull
        public ItemStack m_8020_(int i) {
            return ItemStack.f_41583_;
        }

        @Nonnull
        public ItemStack m_7407_(int i, int i1) {
            return ItemStack.f_41583_;
        }

        @Nonnull
        public ItemStack m_8016_(int i) {
            return ItemStack.f_41583_;
        }

        public void m_6836_(int i, @Nonnull ItemStack itemStack) {
        }

        public void m_6596_() {
        }

        public boolean m_6542_(@Nonnull Player playerEntity) {
            return false;
        }

        public void m_6211_() {
            this.identifiers.clear();
        }
    }

    public static class BlockStateInventory
    extends IdentifierInventory {
        private BlockState state;

        public BlockStateInventory(Bee bee1, BlockState state) {
            super(bee1, "");
            this.state = state;
        }

        public BlockState getState() {
            return this.state;
        }
    }
}

